/*************************************************************************
 * The contents of this file are subject to the MYRICOM MX AND GM-2      *
 * MAPPING SOFTWARE AND DOCUMENTATION LICENSE (the "License"); User may  *
 * not use this file except in compliance with the License.  The full    *
 * text of the License can found in mapper directory in LICENSE.TXT      *
 *                                                                       *
 * Software distributed under the License is distributed on an "AS IS"   *
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied.  See  *
 * the License for the specific language governing rights and            *
 * limitations under the License.                                        *
 *                                                                       *
 * Copyright 2003 - 2004 by Myricom, Inc.  All rights reserved.          *
 *************************************************************************/

#ifndef lx_route_file_h
#define lx_route_file_h

#ifdef	__cplusplus
extern "C"
{
#if 0
}
#endif
#endif

#include "lx.h"

typedef struct lx_route_table_entry_t
{
  int valid;
  lx_route_t route;
}lx_route_table_entry_t;

#define lx_route_file_entry(e, num_ports, num_hosts, num_routes, iport, to, oiport, index)&e[(num_ports) * (num_ports) * (num_routes) * (to) + (num_ports) * (num_routes) * (iport) + (num_routes) * (oiport) + index]

int lx_route_file_write_header (FILE*fp, lx_map_t*m, lx_node_t*me, int num_ports, int num_routes);
int lx_route_file_write_route (FILE*fp, int iport, int host, int index, int oiport, lx_route_t*route);
int lx_route_file_write_routes (FILE*fp, lx_map_t*m, lx_node_t*me, int iport, int index);
lx_route_table_entry_t*lx_route_file_read_routes (FILE*fp, int*from, int*num_hosts, int*num_ports, int*num_routes, int*line_count);
int lx_route_file_read_route (char*route_string, lx_route_t*route);

#ifdef __cplusplus
#if 0
{
#endif
}
#endif

#endif /*lx_route_file_h*/
